__prompt_color_enabled="$(command -v tput)"
__prompt_color_colors="$(! [ "$__prompt_color_enabled" ] || tput colors)"

__prompt_color()
{

  [ "$__prompt_color_enabled" ] || return 0

  __prompt_color="${PROMPT_COLOR:-15}"
  if [ "$__prompt_color_colors" -lt "$__prompt_color" ]
  then
    __prompt_color="$((__prompt_color - 8))"
    __prompt_color_bold='bold'
  fi

  printf "$1" "$(
    tput -S << EOF
      $__prompt_color_bold
      setaf $__prompt_color
      $2
EOF
  )"
}
