[ "$(command -v gnome-terminal)" ] || return 0
[ "$(command -v gsettings     )" ] || return 0

# https://wiki.gnome.org/Apps/Terminal/FAQ#How_can_I_change_a_profile_setting_from_the_command_line.3F
__gnome_terminal_gsettings()
{
  gsettings set \
    "$(printf '%s:/%s:/:%s/' \
      'org.gnome.Terminal.Legacy.Profile' \
      'org/gnome/terminal/legacy/profiles' \
      "$(gsettings get 'org.gnome.Terminal.ProfilesList' "$1" | tr -d "'")"
    )" \
    "$2" \
    "$3"
}

gsettings set 'org.gnome.Terminal.Legacy.Settings' \
  'headerbar' 'false'
gsettings set 'org.gnome.Terminal.Legacy.Settings' \
  'default-show-menubar' 'false'

__gnome_terminal_gsettings 'default' 'rewrap-on-resize'     'true'
__gnome_terminal_gsettings 'default' 'scrollbar-policy'     'never'
__gnome_terminal_gsettings 'default' 'scrollback-unlimited' 'true'
__gnome_terminal_gsettings 'default' 'scroll-on-output'     'false'
__gnome_terminal_gsettings 'default' 'scroll-on-keystroke'  'true'

__gnome_terminal_gsettings 'default' 'enable-sixel' 'true'

__gnome_terminal_gsettings 'default' 'use-system-font' 'false'
__gnome_terminal_gsettings 'default' 'font'            'Monospace 10'

__gnome_terminal_gsettings 'default' 'use-theme-transparency'          'false'
__gnome_terminal_gsettings 'default' 'use-transparent-background'      'true'
__gnome_terminal_gsettings 'default' 'background-transparency-percent' '25'

__gnome_terminal_gsettings 'default' 'use-theme-colors' 'false'
