/// Extensions

//// Install extensions automatically
// Only from the current user's profile.
// https://extensionworkshop.com/documentation/enterprise/enterprise-distribution/#controlling-automatic-installations
user_pref("extensions.autoDisableScopes", 14);

/// Preferences
// about:preferences

//// General
// about:preferences#general

///// Startup
// Open previous windows and tabs
user_pref("browser.startup.page", 3);

///// Tabs
// Confirm before closing multiple tabs
user_pref("browser.tabs.warnOnClose", true);

///// Digital Rights Management (DRM) Content
// Play DRM-controlled content
user_pref("media.eme.enabled", true);

///// Browsing
// Recommend extensions as you browse
user_pref("browser.newtabpage.activity-stream.asrouter.userprefs.cfr.addons", false);
// Recommend features as you browse
user_pref("browser.newtabpage.activity-stream.asrouter.userprefs.cfr.features", false);

///// Network Settings
// Enable DNS over HTTPS
// user_pref("doh-rollout.disable-heuristics", true);
// user_pref("network.trr.mode", 2);
// Use Provider: Cloudflare (Default)
// user_pref("network.trr.uri", "https://mozilla.cloudflare-dns.com/dns-query");
// Use Provider: Custom
// user_pref("network.trr.uri", "https://dns.quad9.net/dns-query");
// user_pref("network.trr.custom_uri", "https://dns.quad9.net/dns-query");

//// Home
// about:preferences#home

///// New Windows and Tabs
// Homepage and new windows: Blank Page
user_pref("browser.startup.homepage", "about:blank");
// New tabs: Blank Page
user_pref("browser.newtabpage.enabled", false);

///// Firefox Home Content
// Shortcuts: Sponsored shortcuts
user_pref("browser.newtabpage.activity-stream.showSponsoredTopSites", false);

//// Search
// about:preferences#search

///// Default Search Engine
// DuckDuckGo
// user_pref("browser.urlbar.placeholderName", "DuckDuckGo");
// Google
user_pref("browser.urlbar.placeholderName", "Google");

///// Search Suggestions
// Show search suggestions ahead of browsing history in address bar results
user_pref("browser.urlbar.showSearchSuggestionsFirst", false);

//// Privacy & Security
// about:preferences#privacy

///// Browser Privacy
// Enhanced Tracking Protection: Strict
user_pref("browser.contentblocking.category", "strict");
user_pref("network.cookie.cookieBehavior", 5);
user_pref("network.http.referer.disallowCrossSiteRelaxingDefault", true);
user_pref("privacy.annotate_channels.strict_list.enabled", true);
user_pref("privacy.partition.network_state.ocsp_cache", true);
user_pref("privacy.trackingprotection.enabled", true);
user_pref("privacy.trackingprotection.socialtracking.enabled", true);
// Logins and Passwords: Ask to save logins and passwords for websites
user_pref("signon.rememberSignons", false);
// Address Bar: Browsing history
user_pref("browser.urlbar.suggest.history", false);
// Address Bar: Bookmarks
user_pref("browser.urlbar.suggest.bookmark", true);
// Address Bar: Open tabs
user_pref("browser.urlbar.suggest.openpage", false);
// Address Bar: Shortcuts
user_pref("browser.urlbar.suggest.topsites", false);
// Address Bar: Search engines
user_pref("browser.urlbar.suggest.engines", false);

///// Firefox Data Collection and Use
// Allow Firefox to send technical and interaction data to Mozilla
user_pref("datareporting.healthreport.uploadEnabled", false);
// Allow Firefox to install and run studies
user_pref("app.shield.optoutstudies.enabled", false);

///// Security
// Block dangerous and deceptive content
user_pref("browser.safebrowsing.malware.enabled", false);
user_pref("browser.safebrowsing.phishing.enabled", false);
// HTTPS-Only Mode: Enable HTTPS-Only Mode in all windows
user_pref("dom.security.https_only_mode", true);
user_pref("dom.security.https_only_mode_ever_enabled", true);

/// User interface
// Don't hide toolbars in fullscreen
user_pref("browser.fullscreen.autohide", false);

/// Clipboard
// Disable legacy `document.execCommand()` with `"cut"` and `"copy"` arguments.
// <https://developer.mozilla.org/en-US/docs/Web/API/Document/execCommand#cut>
// <https://developer.mozilla.org/en-US/docs/Web/API/Document/execCommand#copy>
user_pref("dom.allow_cut_copy", false);
// Disable `document.addEventListener()` with `"cut"`, `"copy"`, and `"paste"`
// arguments.
// <https://developer.mozilla.org/en-US/docs/Web/API/Document/cut_event>
// <https://developer.mozilla.org/en-US/docs/Web/API/Document/copy_event>
// <https://developer.mozilla.org/en-US/docs/Web/API/Document/paste_event>
user_pref("dom.event.clipboardevents.enabled", false);
// Disable `window.navigator.clipboard` `read{,Text}` and `write{,Text}` async
// calls, which take/return a `ClipboardItem` (formerly `DataTransfer`). (Only
// `read` requires explicit permission from the user, not `write`.)
// <https://developer.mozilla.org/en-US/docs/Web/API/Window/navigator>
// <https://developer.mozilla.org/en-US/docs/Web/API/Navigator/clipboard>
// <https://developer.mozilla.org/en-US/docs/Web/API/Clipboard>
// <https://developer.mozilla.org/en-US/docs/Web/API/ClipboardItem>
// <https://developer.mozilla.org/en-US/docs/Web/API/ClipboardEvent>
// <https://developer.mozilla.org/en-US/docs/Web/API/ClipboardItem>
// <https://hg.mozilla.org/mozilla-central/rev/7ea0b5653ebeb4ccf6f697bac20698725e2b44c7>
// <https://hg.mozilla.org/mozilla-central/rev/7dedaec9dba5faa3d3549ca868ccc278e293db42>
user_pref("dom.events.asyncClipboard.dataTransfer", false);
user_pref("dom.events.asyncClipboard.clipboardItem", false);
user_pref("dom.events.asyncClipboard.readText", false);

/// firefox-profilemaker

//// Annoyances

///// Disable firefox intro tabs on the first start
// Disable the first run tabs with advertisements for the latest firefox
// features.
user_pref("browser.startup.homepage_override.mstone", "ignore");

///// Disable new tab page intro
// Disable the intro to the newtab page on the first run
user_pref("browser.newtabpage.introShown", true);

///// Pocket Reading List
// Disable Pocket
user_pref("extensions.pocket.enabled", false);
user_pref("browser.newtabpage.activity-stream.section.highlights.includePocket", false);

///// Disable Sponsored Top Sites
// Firefox 83 introduced sponsored top sites, which are sponsored ads displayed
// as suggestions in the URL bar.
user_pref("services.sync.prefs.sync.browser.newtabpage.activity-stream.showSponsoredTopSite", false);

///// Disable about:config warning.
user_pref("browser.aboutConfig.showWarning", false);

///// Do not trim URLs in navigation bar
// By default Firefox trims many URLs (hiding the http:// prefix and trailing
// slash /).
user_pref("browser.urlbar.trimURLs", false);

///// Disable checking if Firefox is the default browser
user_pref("browser.shell.checkDefaultBrowser", false);

///// Disable reset prompt.
// When Firefox is not used for a while, it displays a prompt asking if the
// user wants to reset the profile. (see Bug #955950).
user_pref("browser.disableResetPrompt", true);

///// Disable Heartbeat Userrating
// With Firefox 37, Mozilla integrated the Heartbeat system to ask users from
// time to time about their experience with Firefox.
user_pref("browser.selfsupport.url", "");

///// Content of the new tab page
// Thumbnails of the most visited pages
user_pref("browser.newtabpage.enhanced", false);

///// Disable autoplay of <video> tags.
// Per default, <video> tags are allowed to start automatically. Note: When
// disabling autoplay, you will have to click pause and play again on some
// video sites.
// Allow autoplay
user_pref("media.autoplay.enabled", true);
user_pref("media.autoplay.default", 0);

//// Browser Features

///// Disable Telemetry
// The telemetry feature sends data about the performance and responsiveness of
// Firefox to Mozilla.
user_pref("toolkit.telemetry.enabled", false);
user_pref("toolkit.telemetry.archive.enabled", false);
user_pref("toolkit.telemetry.rejected", true);
user_pref("toolkit.telemetry.unified", false);
user_pref("toolkit.telemetry.unifiedIsOptIn", false);
user_pref("toolkit.telemetry.prompted", 2);
user_pref("toolkit.telemetry.server", "");
user_pref("toolkit.telemetry.cachedClientID", "");
user_pref("toolkit.telemetry.newProfilePing.enabled", false);
user_pref("toolkit.telemetry.shutdownPingSender.enabled", false);
user_pref("toolkit.telemetry.updatePing.enabled", false);
user_pref("toolkit.telemetry.bhrPing.enabled", false);
user_pref("toolkit.telemetry.firstShutdownPing.enabled", false);
user_pref("toolkit.telemetry.hybridContent.enabled", false);
user_pref("toolkit.telemetry.reportingpolicy.firstRun", false);

///// Disable health report
// Disable sending Firefox health reports to Mozilla
user_pref("datareporting.healthreport.uploadEnabled", false);
user_pref("datareporting.policy.dataSubmissionEnabled", false);
user_pref("datareporting.healthreport.service.enabled", false);

///// Disable shield studies
// Mozilla shield studies is a feature which allows mozilla to remotely install
// experimental addons.
user_pref("app.normandy.enabled", false);
user_pref("app.normandy.api_url", "");
user_pref("app.shield.optoutstudies.enabled", false);
user_pref("extensions.shield-recipe-client.enabled", false);
user_pref("extensions.shield-recipe-client.api_url", "");

///// Disable experiments
// Telemetry Experiments is a feature that allows Firefox to automatically
// download and run specially-designed restartless addons based on certain
// conditions.
user_pref("experiments.enabled", false);
user_pref("experiments.manifest.uri", "");
user_pref("experiments.supported", false);
user_pref("experiments.activeExperiment", false);
user_pref("network.allow-experiments", false);

///// Disable Crash Reports
// The crash report may contain data that identifies you or is otherwise
// sensitive to you.
user_pref("breakpad.reportURL", "");
user_pref("browser.tabs.crashReporting.sendReport", false);
user_pref("browser.crashReports.unsubmittedCheck.enabled", false);
user_pref("browser.crashReports.unsubmittedCheck.autoSubmit", false);
user_pref("browser.crashReports.unsubmittedCheck.autoSubmit2", false);

///// Opt out metadata updates
// Firefox sends data about installed addons as metadata updates, so Mozilla is
// able to recommend you other addons.
user_pref("extensions.getAddons.cache.enabled", false);

///// Disable google safebrowsing
// Google safebrowsing can detect phishing and malware but it also sends
// informations to google together with an unique id called wrkey.
user_pref("browser.safebrowsing.enabled", false);
user_pref("browser.safebrowsing.downloads.remote.url", "");
user_pref("browser.safebrowsing.phishing.enabled", false);
user_pref("browser.safebrowsing.blockedURIs.enabled", false);
user_pref("browser.safebrowsing.downloads.enabled", false);
user_pref("browser.safebrowsing.downloads.remote.enabled", false);
user_pref("browser.safebrowsing.appRepURL", "");
user_pref("browser.safebrowsing.malware.enabled", false);

///// Disable malware scan
// The malware scan sends an unique identifier for each downloaded file to
// Google.
user_pref("browser.safebrowsing.appRepURL", "");
user_pref("browser.safebrowsing.malware.enabled", false);

///// Disable DNS over HTTPS
// DNS over HTTP (DoH), aka. Trusted Recursive Resolver (TRR), uses a server
// run by Cloudflare to resolve hostnames, even when the system uses another
// (normal) DNS server. This setting disables it and sets the mode to
// explicit opt-out (5).
user_pref("network.trr.mode", 5);

///// Disable preloading of the new tab page.
// By default Firefox preloads the new tab page (with website thumbnails) in
// the background before it is even opened.
user_pref("browser.newtab.preload", false);

///// Disable about:addons' Get Add-ons panel
// The start page with recommended addons uses google analytics.
user_pref("extensions.getAddons.showPane", false);
user_pref("extensions.webservice.discoverURL", "");

///// Disable check for captive portal.
// By default, Firefox checks for the presence of a captive portal on every
// startup.  This involves traffic to Akamai.
user_pref("network.captive-portal-service.enabled", false);

///// Disables playback of DRM-controlled HTML5 content
// if enabled, automatically downloads the Widevine Content Decryption Module
// provided by Google Inc. Details
user_pref("media.eme.enabled", false);

///// Disables the Widevine Content Decryption Module provided by Google Inc.
// Used for the playback of DRM-controlled HTML5 content Details
user_pref("media.gmp-widevinecdm.enabled", false);

///// Disable access to device sensor data
// Disallow websites to access sensor data (ambient light, motion, device
// orientation and proximity data).
user_pref("device.sensors.ambientLight.enabled", false);
user_pref("device.sensors.enabled", false);
user_pref("device.sensors.motion.enabled", false);
user_pref("device.sensors.orientation.enabled", false);
user_pref("device.sensors.proximity.enabled", false);

///// Disable Firefox Suggest
// The Firefox Suggest feature allows Mozilla to provide search suggestions in
// the US, which uses your city location and search keywords to send
// suggestions. This is also used to serve advertisements.
user_pref("browser.urlbar.groupLabels.enabled", false);
user_pref("browser.urlbar.quicksuggest.enabled", false);

///// Disable Javascript in PDF viewer
// Disables executing of JavaScript in the PDF form viewer. It is possible that
// some PDFs are not rendered correctly due to missing functions.
// user_pref("pdfjs.enableScripting", false);

//// Privacy

///// Fake another Useragent
// Using a popular useragent string avoids attracting attention i.e. with an
// Iceweasel UA. (keep blank to use the default)
// user_pref("general.useragent.override", "");

///// Block Cookies
// Block 3rd-Party cookies or even all cookies.
// Block Cookies, which are not from the site you're visiting. You will rarely
// notice that something is missing, but it hugely improves your privacy.
user_pref("network.cookie.cookieBehavior", 1);

///// Block Referer
// Firefox tells a website, from which site you're coming (the so called
// referer). You can find more detailed settings in this ghacks article or
// install the RefControl extension for per domain settings.
// Spoof referer (send the same url)
user_pref("network.http.referer.spoofSource", true);

///// Disable DOM storage
// Disables DOM storage, which enables so called "supercookies". Some modern
// sites will not work (i.e. missing "save" functions).
// user_pref("dom.storage.enabled", false);

///// Disable IndexedDB (breaks things)
// IndexedDB is a way, websites can store structured data. This can be abused
// for tracking, too. Disabling causes problems when sites depend on it like
// Tweetdeck or Reddit and extensions that use it to store their data. Some
// users reported crashing tabs when IndexedDB is disabled. Only disable it,
// when you know what you're doing.
// user_pref("dom.indexedDB.enabled", false);

///// Disable the Offline Cache.
// Websites can store up to 500 MB of data in an offline cache, to be able to
// run even when there is no working internet connection. This could
// possibly be used to store an user id.
user_pref("browser.cache.offline.enable", false);

///// Sessionstore Privacy
// This preference controls when to store extra information about a session:
// contents of forms, scrollbar positions, cookies, and POST data.
// Never store extra session data
user_pref("browser.sessionstore.privacy_level", 2);

///// Disable Link Prefetching
// Firefox prefetches the next site on some links, so the site is loaded even
// when you never click.
user_pref("network.prefetch-next", false);
user_pref("network.dns.disablePrefetch", true);
user_pref("network.dns.disablePrefetchFromHTTPS", true);
user_pref("network.predictor.enabled", false);
user_pref("network.predictor.enable-prefetch", false);

///// Disable speculative website loading.
// In some situations Firefox already starts loading web pages when the mouse
// pointer is over a link, i. e. before you actually click. This is to speed
// up the loading of web pages by a few milliseconds.
user_pref("network.http.speculative-parallel-limit", 0);
user_pref("browser.urlbar.speculativeConnect.enabled", false);

///// Use a private container for new tab page thumbnails
// Load the pages displayed on the new tab page in a private container when
// creating thumbnails.
user_pref("privacy.usercontext.about_newtab_segregation.enabled", true);

///// Disable WebGL
// Disables the WebGL function, to prevent fingerprinting with WebGL. Another
// issue is, that websites can (ab)use the full power of the graphics card.
// WebGL is part of some fingerprinting scripts used in the wild. Some
// interactive websites will not work, which are mostly games.
user_pref("webgl.disabled", true);

///// Override graphics card vendor and model strings in the WebGL API
// Websites can read the graphics card vendor and model using a WebGL API. This
// setting overrides both with " " without disabling WebGL.
user_pref("webgl.renderer-string-override", " ");
user_pref("webgl.vendor-string-override", " ");

///// Disable WebRTC
// Disables the WebRTC function, which gives away your local ips. Some addons
// like uBlock origin provide settings to prevent WebRTC from exposing local
// ips without disabling WebRTC.
user_pref("media.peerconnection.enabled", false);

///// Disable the clipboardevents.
// Disable that websites can get notifications if you copy, paste, or cut
// something from a web page, and it lets them know which part of the page
// had been selected.
user_pref("dom.event.clipboardevents.enabled", false);

///// Disable Search Suggestions
// Firefox suggests search terms in the search field. This will send everything
// typed or pasted in the search field to the chosen search engine, even
// when you did not press enter.
// user_pref("browser.search.suggest.enabled", false);

///// Disable Search Keyword
// When you mistype some url, Firefox starts a search even from urlbar. This
// feature is useful for quick searching, but may harm your privacy, when
// it's unintended.
// user_pref("keyword.enabled", false);

///// Disable Fixup URLs
// When you type "something" in the urlbar and press enter, Firefox tries
// "something.com", if Fixup URLs is enabled.
// user_pref("browser.fixup.alternate.enabled", false);

//// Website Tracking

///// Enable Do-not-Track
// With the do not track feature, you tell websites, that you do not want to be
// tracked. Most websites ignore this, so you need other privacy options as
// well.
user_pref("privacy.donottrackheader.enabled", true);
user_pref("privacy.donottrackheader.value", 1);

///// Enable resistFingerprinting
// The privacy.resistFingerprinting setting coming from the tor-browser hides
// some system properties. See Bug #1308340 for more information. This
// option may interfere with other privacy related settings, see the
// discussion in our bug tracker.
// user_pref("privacy.resistFingerprinting", true);

///// Enable Mozilla Trackingprotection
// Firefox has a builtin tracking protection, which blocks a list of known
// tracking sites.
user_pref("privacy.trackingprotection.pbmode.enabled", true);
user_pref("privacy.trackingprotection.enabled", true);
user_pref("privacy.trackingprotection.fingerprinting.enabled", true);
user_pref("privacy.trackingprotection.cryptomining.enabled", true);

///// Enable firstparty isolation.
// FPI works by separating cookies on a per-domain basis. In this way tracking
// networks won't be able to locate the same cookie on different sites. Note
// that this might break third-party logins.
// user_pref("privacy.firstparty.isolate", true);

///// Disable Browser Pings
// Firefox sends "ping" requests, when a website requests to be informed when a
// user clicks on a link.
user_pref("browser.send_pings", false);

///// Disable TLS session identifiers
// TLS allows for session identifieres, which speed up the session resumption
// when a connection was lost. These identifiers can be used for tracking.
user_pref("security.ssl.disable_session_identifiers", true);

///// Disable Beacons
// The Beacon feature allows websites to send tracking data after you left the
// website.
user_pref("beacon.enabled", false);

///// Disable the Battery API
// Firefox allows websites to read the charge level of the battery. This may be
// used for fingerprinting.
user_pref("dom.battery.enabled", false);

///// Disable media device queries
// Prevent websites from accessing information about webcam and microphone
// (possible fingerprinting).
user_pref("media.navigator.enabled", false);

///// Disable form autofill
// Automatically filled form fields are used for fingerprinting. This setting
// disables automatic form filling until you click on the field.
user_pref("signon.autofillForms", false);

///// Disable webaudio API
// Disable webaudio API to prevent browser fingerprinting. See Mozilla Bug
// #1288359. This can break web apps, like Discord, which rely on the API.
user_pref("dom.webaudio.enabled", false);

///// Disable video statistics
// Prevent websites from measuring video performance (possible fingerprinting).
// See Mozilla Bug 654550.
user_pref("media.video_stats.enabled", false);

//// Security

///// Disable automatic updates.
// Updates are no longer installed automatically. You will still be notified
// when an update is available and can install it. Avoids getting a new
// (maybe addon incompatible) version.
user_pref("app.update.auto", false);

///// Disable searching for updates.
// Disable searching for updates. This only works with the enterprise policy
// download..

///// Disable extension blocklist from mozilla.
// The extension blocklist is used by mozilla to deactivate individual addons
// in the browser, but as a side effect it gives mozilla the ultimate
// control to disable any extension. Caution: When you disable the
// blocklist, you may keep using known malware addons.
// user_pref("extensions.blocklist.enabled", false);

///// Show Punycode.
// This helps to protect against possible character spoofing.
// user_pref("network.IDN_show_punycode", true);
