/// Extensions

//// Install extensions automatically
// Only from the current user's profile.
// https://extensionworkshop.com/documentation/enterprise/enterprise-distribution/#controlling-automatic-installations
user_pref("extensions.autoDisableScopes", 14);

/// Preferences
// about:preferences

//// General
// about:preferences#general

///// Startup
// Open previous windows and tabs
user_pref("browser.startup.page", 3);

///// Tabs
// Confirm before closing multiple tabs
user_pref("browser.tabs.warnOnClose", true);

///// Digital Rights Management (DRM) Content
// Play DRM-controlled content
user_pref("media.eme.enabled", true);

///// Browsing
// Recommend extensions as you browse
user_pref("browser.newtabpage.activity-stream.asrouter.userprefs.cfr.addons", false);
// Recommend features as you browse
user_pref("browser.newtabpage.activity-stream.asrouter.userprefs.cfr.features", false);

///// Network Settings
// Enable DNS over HTTPS
// user_pref("doh-rollout.disable-heuristics", true);
// user_pref("network.trr.mode", 2);
// Use Provider: Cloudflare (Default)
// user_pref("network.trr.uri", "https://mozilla.cloudflare-dns.com/dns-query");
// Use Provider: Custom
// user_pref("network.trr.uri", "https://dns.quad9.net/dns-query");
// user_pref("network.trr.custom_uri", "https://dns.quad9.net/dns-query");

//// Home
// about:preferences#home

///// New Windows and Tabs
// Homepage and new windows: Blank Page
user_pref("browser.startup.homepage", "about:blank");
// New tabs: Blank Page
user_pref("browser.newtabpage.enabled", false);

///// Firefox Home Content
// Shortcuts: Sponsored shortcuts
user_pref("browser.newtabpage.activity-stream.showSponsoredTopSites", false);

//// Search
// about:preferences#search

///// Default Search Engine
// DuckDuckGo
// user_pref("browser.urlbar.placeholderName", "DuckDuckGo");
// Google
user_pref("browser.urlbar.placeholderName", "Google");

///// Search Suggestions
// Show search suggestions ahead of browsing history in address bar results
user_pref("browser.urlbar.showSearchSuggestionsFirst", false);

//// Privacy & Security
// about:preferences#privacy

///// Browser Privacy
// Enhanced Tracking Protection: Strict
user_pref("browser.contentblocking.category", "strict");
user_pref("network.cookie.cookieBehavior", 5);
user_pref("network.http.referer.disallowCrossSiteRelaxingDefault", true);
user_pref("privacy.annotate_channels.strict_list.enabled", true);
user_pref("privacy.partition.network_state.ocsp_cache", true);
user_pref("privacy.trackingprotection.enabled", true);
user_pref("privacy.trackingprotection.socialtracking.enabled", true);
// Logins and Passwords: Ask to save logins and passwords for websites
user_pref("signon.rememberSignons", false);
// Address Bar: Browsing history
user_pref("browser.urlbar.suggest.history", false);
// Address Bar: Bookmarks
user_pref("browser.urlbar.suggest.bookmark", true);
// Address Bar: Open tabs
user_pref("browser.urlbar.suggest.openpage", false);
// Address Bar: Shortcuts
user_pref("browser.urlbar.suggest.topsites", false);
// Address Bar: Search engines
user_pref("browser.urlbar.suggest.engines", false);

///// Firefox Data Collection and Use
// Allow Firefox to send technical and interaction data to Mozilla
user_pref("datareporting.healthreport.uploadEnabled", false);
// Allow Firefox to install and run studies
user_pref("app.shield.optoutstudies.enabled", false);

///// Security
// Block dangerous and deceptive content
user_pref("browser.safebrowsing.malware.enabled", false);
user_pref("browser.safebrowsing.phishing.enabled", false);
// HTTPS-Only Mode: Enable HTTPS-Only Mode in all windows
user_pref("dom.security.https_only_mode", true);
user_pref("dom.security.https_only_mode_ever_enabled", true);

/// User interface
// Don't hide toolbars in fullscreen
user_pref("browser.fullscreen.autohide", false);
