# [`dotd`][]

Generate a file from fragment files in a directory.

`dotd` is intended to be used to (re-)generate e.g. a configuration file
`config` from files in a corresponding directory `config.d` where separate
people or programs can place configuration fragment files without treading on
each other's toes, when the native configuration language does not support
functionality equivalent to `include config.d/*`. In essence, it is a glorified
`cat config.d/* > config`.

[`dotd`]: https://git.rcrnstn.net/rcrnstn/dotd

## Usage

`dotd --help`:

```
dotd 1.0

Generate a file from fragment files in a directory.

usage:
  dotd [options] [--] <file> [<dir>]
  dotd -h|--help
  dotd --version

arguments:
  <file>
    File to generate. Specify - to print to stdout instead.

  <dir>
    Directory containing fragment files. <file>.d is used if not
    specified.

options:
  -a, --action <action>
    Action to perform on each fragment file. E.g.
      printf "#include \"%s\"\n"
    [default: cat]

  -c, --comment <comment>
    If non-empty, adds comments starting with <comment> that the file is
    auto-generated and which fragment corresponds to which file.
    [default: ]

  -g, --glob <glob>
    Shell glob used to find fragment files, relative to <dir>.
    [default: *]

  -v, --validate <validate>
    Command to run on the (temporary) generated file. Only if the command
    returns success is the file moved to its final destination. E.g.
      /usr/sbin/sshd -t -f
    [default: ]
```

## Dependencies

All dependencies are [POSIX][] and are highly likely to be installed by default
(e.g. they all have the [Debian priority][] `required`).

-   `sh` (e.g. from [`bash`][] or [`dash`][])
-   `sed` (e.g. from [`sed`][])
-   `awk` (e.g. from [`mawk`][])

[POSIX]: https://en.wikipedia.org/wiki/POSIX
[Debian priority]: https://www.debian.org/doc/debian-policy/ch-archive.html#s-priorities
[`bash`]: https://packages.debian.org/bash
[`dash`]: https://packages.debian.org/dash
[`sed`]: https://packages.debian.org/sed
[`mawk`]: https://packages.debian.org/mawk

## Related projects

-   [Ansible][]'s [`assemble` module][].
-   [Puppet][]'s [`concat` module][].

[Ansible]: https://en.wikipedia.org/wiki/Ansible_(software)
[`assemble` module]: https://docs.ansible.com/ansible/latest/collections/ansible/builtin/assemble_module.html
[Puppet]: https://en.wikipedia.org/wiki/Puppet_(software)
[`concat` module]: https://forge.puppet.com/modules/puppetlabs/concat

## License

Licensed under the [ISC License][] unless otherwise noted, see the
[`LICENSE`][] file.

[ISC License]: https://choosealicense.com/licenses/isc/
[`LICENSE`]: LICENSE
