# [`cxx-maze`][]

A simple C++11 command line maze generator.

Features:

-   Printing (with buffering)
-   Callback during generation
-   Algorithms
    -   Hunt And Kill
        -   Handles mazes of any size
        -   Random with seed (time in seconds since the epoch by default)
        -   Fairly slow (1000*1000 cells in ~4000ms)

[`cxx-maze`]: https://git.rcrnstn.net/rcrnstn/cxx-maze

## Example

```
$ make
$ ./maze dummy
3844ms
$ ./maze
██  ████████████████████████████████████████████████████████████████████████████
██  ██                          ██              ██      ██          ██      ████
██  ██  ██  ██████████████  ██████  ██  ██████  ██  ██  ██  ██  ██  ██  ██  ████
██      ██  ██          ██  ██      ██      ██      ██      ██  ██  ██  ██  ████
██  ██████  ██  ██  ██  ██████  ██████  ██  ██  ██████████████  ██  ██  ██  ████
██      ██      ██  ██      ██      ██  ██  ██          ██      ██      ██  ████
██  ██  ██████████  ██  ██  ██████  ██  ██  ██████████████  ██████████  ██  ████
██  ██      ██      ██  ██      ██  ██  ██              ██  ██      ██  ██  ████
██  ██████  ██  ██████████████  ██  ██  ██████████████  ██████  ██  ██████  ████
██  ██      ██              ██      ██  ██              ██      ██          ████
██████  ██  ██████████████  ██████████████  ██  ██  ██████  ████████████████████
██      ██  ██      ██      ██              ██  ██  ██  ██                  ████
██  ██████  ██  ██████  ██  ██  ██████████████  ██  ██  ██  ██  ██████████  ████
██  ██      ██          ██  ██      ██          ██      ██  ██  ██      ██  ████
██  ██  ██████████████  ██  ██████  ██████████████████  ██  ██  ██  ██████  ████
██  ██  ██          ██  ██  ██      ██              ██  ██  ██  ██  ██      ████
██  ██  ██  ██  ██  ██  ██  ██  ██████  ██  ██████  ██  ██  ██████  ██  ████████
██  ██  ██  ██  ██  ██  ██  ██  ██      ██      ██  ██  ██      ██  ██      ████
██  ██████  ██  ██  ██████  ██  ██  ██████████████  ██  ██████  ██  ██████  ████
██  ██      ██  ██  ██      ██  ██  ██      ██      ██      ██  ██      ██  ████
██  ██  ██████████  ██  ██████  ██  ██  ██  ██  ██████████  ██  ██████  ██  ████
██      ██          ██      ██      ██  ██      ██          ██      ██      ████
██████████████████████████████████████████████████████████████████████████  ████
```

<style>#example ~ pre { line-height: 1; }</style>

## License

Licensed under the [ISC License][] unless otherwise noted, see the
[`LICENSE`][] file.

[ISC License]: https://choosealicense.com/licenses/isc
[`LICENSE`]: LICENSE
