# [`cryptgen`][]

A thin command-line wrapper around [`crypt(3)`][] and [`crypt_gensalt(3)`][].

**NOTE**: This security-related software includes no error checking and uses
functions whose documentation states "This function is obsolete. Do not use
it.". Results are platform-dependent and should be verified manually. It exists
because its constituent 13 non-empty lines of C provides functionality
(specifically [`yescrypt`][], the default password hashing scheme on many Linux
distributions, with automatic parameter encoding and salt generation) that at
the time of writing is not easily accessible from the command line elsewhere
([OpenSSL's `passwd`][], [Perl's `crypt`][], [Python's `crypt`][], [Python's
`hashlib`][]).

[`cryptgen`]: https://git.rcrnstn.net/rcrnstn/cryptgen
[`crypt(3)`]: https://manpages.debian.org/crypt.3
[`crypt_gensalt(3)`]: https://manpages.debian.org/crypt_gensalt.3
[`yescrypt`]: https://www.openwall.com/yescrypt
[OpenSSL's `passwd`]: https://github.com/openssl/openssl/issues/19340
[Perl's `crypt`]: https://perldoc.perl.org/functions/crypt
[Python's `crypt`]: https://docs.python.org/3/library/crypt
[Python's `hashlib`]: https://docs.python.org/3/library/hashlib

## Usage

```
cryptgen [<prefix> [<count>]]
```

where the valid values of the optional `<prefix>` (hashing method) and
`<count>` ("CPU time cost") parameters are documented in [`crypt(5)`][]. On
most distributions, if `<prefix>` is not given the best available hashing
method will be selected, if `<count>` is not given a low default cost will be
selected.

[`crypt(5)`]: https://manpages.debian.org/crypt.5

## License

Licensed under the [BSD Zero Clause License][] unless otherwise noted, see the
[`LICENSE`][] file.

[BSD Zero Clause License]: https://choosealicense.com/licenses/0bsd
[`LICENSE`]: LICENSE
