# [`crany`][]

**C**oncept-based **R**elaying **Any** C++14 type.

For a usage example, see `tests/crany.cpp`.

For a diagram visualizing the implementation, see `doc/crany.dot.png`.

[`crany`]: https://git.rcrnstn.net/rcrnstn/crany

## References

The references below focus on the timeline and online resources.

This work builds on that of many others:

-   Chris Cleeland, Douglas Schmidt, Timothy Harrison
    -   External Polymorphism
        -   1996, Proceedings of the 3rd Pattern Languages of Programming Conference, [paper](https://www.dre.vanderbilt.edu/~schmidt/PDF/C++-EP.pdf)
-   Kevlin Henney
    -   Valued Conversions
        -   2000, C++ Report, [paper](https://citeseerx.ist.psu.edu/viewdoc/download?doi=10.1.1.374.2252&rep=rep1&type=pdf)
-   Sean Parent
    -   Runtime Concepts: Generic Programming and Runtime Polymorphism
        -   Unpublished, [paper](https://stlab.cc/legacy/runtime-concepts.html)
    -   Concept-Based Runtime Polymorphism
        -   2007, BoostCon, [slides](https://stlab.cc/legacy/figures/Boost_poly.pdf)
    -   Value Semantics and Concept-based Polymorphism
        -   2012, C++Now, [talk](https://www.youtube.com/watch?v=_BpMYeUFXv8), [slides](https://sean-parent.stlab.cc/papers-and-presentations/#value-semantics-and-concept-based-polymorphism)
    -   Inheritance Is The Base Class of Evil
        -   2013, GoingNative, [talk](https://www.youtube.com/watch?v=bIhUE5uUFOA), [slides](https://sean-parent.stlab.cc/papers-and-presentations/#inheritance-is-the-base-class-of-evil)
    -   Better Code: Runtime Polymorphism
        -   2017, NDC, [talk](https://www.youtube.com/watch?v=QGcVXgEVMJg), [slides](https://sean-parent.stlab.cc/papers-and-presentations/#better-code-runtime-polymorphism)
-   Louis Dionne
    -   Runtime Polymorphism: Back to the Basics
        -   2017, CppCon, [talk](https://www.youtube.com/watch?v=gVGtNFg4ay0), [slides](https://ldionne.com/cppcon-2017-runtime-polymorphism)
        -   2018, ACCU, [talk](https://www.youtube.com/watch?v=H8lFldGvt9w), [slides](https://ldionne.com/accu-2018-runtime-polymorphism)
        -   2018, C++Now, [talk](https://www.youtube.com/watch?v=OtU51Ytfe04), [slides](https://ldionne.com/cppnow-2018-runtime-polymorphism)

Other related work:

-   Zach Laine
    -   Pragmatic Type Erasure: Solving OOP Problems w/ Elegant Design Pattern
        -   2014, CppCon, [talk](https://www.youtube.com/watch?v=0I0FD3N5cgM)
-   Sy Brand
    -   Dynamic Polymorphism with Metaclasses and Code Injection
        -   2020, CppCon, [talk](https://www.youtube.com/watch?v=8c6BAQcYF_E)
-   Klaus Igelberger
    -   Breaking Dependencies: Type Erasure - A Design Analysis
        -   2021, CppCon, [talk](https://www.youtube.com/watch?v=4eeESJQk-mw&t=23m26s)

Related projects:

-   Adobe's [Poly](https://stlab.adobe.com/group__poly__related.html) (of which Sean Parent was a principal contributor)
-   Louis Dionne's [Dyno](https://github.com/ldionne/dyno)
-   Facebook's [Folly Poly](https://github.com/facebook/folly/blob/main/folly/docs/Poly.md)

Related patterns:
-   Adapter pattern
    -   [Wikipedia](https://en.wikipedia.org/wiki/Adapter_pattern)
    -   [GoF Design Patterns](https://en.wikipedia.org/wiki/Design_Patterns)
-   Decorator pattern
    -   [Wikipedia](https://en.wikipedia.org/wiki/Decorator_pattern)
    -   [GoF Design Patterns](https://en.wikipedia.org/wiki/Design_Patterns)
-   External Polymorphism pattern
    -   [WikiWikiWeb](https://wiki.c2.com/?ExternalPolymorphism)

## Build system

This project supports [CMake][] and uses [`cmake-common`][]. There are several
ways to use it in other CMake-based projects:

-   With [`find_package`][]: ([Package][] and) [install][] it on the system.

-   With [`add_subdirectory`][]: Bundle it.

-   With [`FetchContent`][]: Download it as part of the CMake configure step.

-   With [`cmake-common`][]: Use any of the above methods through a simplified
    interface.

As usual, use [`add_dependencies`][] or [`target_link_libraries`][] (or
`cmake-common`'s `DEPENDENCIES_*`) to declare the dependency.

[CMake]: https://cmake.org
[`cmake-common`]: https://git.rcrnstn.net/rcrnstn/cmake-common
[`FetchContent`]: https://cmake.org/cmake/help/v3.14/module/FetchContent.html
[`add_subdirectory`]: https://cmake.org/cmake/help/v3.14/command/add_subdirectory.html
[`find_package`]: https://cmake.org/cmake/help/v3.14/command/find_package.html
[Package]: #Package
[Install]: #Install
[`add_dependencies`]: https://cmake.org/cmake/help/v3.14/command/add_dependencies.html
[`target_link_libraries`]: https://cmake.org/cmake/help/v3.14/command/target_link_libraries.html

### Configure and generate

To configure and generate a build tree, use `cmake`:

```sh
cmake -B _build
```

To set the build type, pass e.g. `-D`[`CMAKE_BUILD_TYPE`][]`=Release`.

[`cmake`]: https://cmake.org/cmake/help/v3.14/manual/cmake.1.html#generate-a-project-buildsystem
[`CMAKE_BUILD_TYPE`]: https://cmake.org/cmake/help/v3.14/variable/CMAKE_BUILD_TYPE.html

### Build

To build, use [`cmake --build`][]:

```sh
cmake --build _build
```

To disable building tests, pass `-D`[`BUILD_TESTING`][]`=OFF`.

[`cmake --build`]: https://cmake.org/cmake/help/v3.14/manual/cmake.1.html#build-a-project
[`BUILD_TESTING`]: https://cmake.org/cmake/help/v3.14/module/CTest.html

### Test

To run tests, use [`ctest`][]:

```sh
(cd _build && ctest)
```

To show output from failing tests, pass `--output-on-failure`. To show output
from all tests, pass `--verbose`.

[`ctest`]: https://cmake.org/cmake/help/v3.14/manual/ctest.1.html

### Package

To package, use [`cpack`][]:

```sh
(cd _build && cpack)
```

[`cpack`]: https://cmake.org/cmake/help/v3.14/manual/cpack.1.html

### Install

To install onto the current system, use [`cmake --install`][]:

```sh
cmake --install _build
```

To set the prefix, pass e.g. `-D`[`CMAKE_INSTALL_PREFIX`][]`="$HOME/.local"`.

[`cmake --install`]: https://cmake.org/cmake/help/v3.14/manual/cmake.1.html#install-a-project
[`CMAKE_INSTALL_PREFIX`]: https://cmake.org/cmake/help/v3.14/variable/CMAKE_INSTALL_PREFIX.html

## License

Licensed under the [ISC License][] unless otherwise noted, see the
[`LICENSE`][] file.

[ISC License]: https://choosealicense.com/licenses/isc
[`LICENSE`]: LICENSE
