# [`bygglogistik-utils`][]

[Scrape][] [intranet.bygglogistik.se][].

`bygglogistik-utils` is a [Python][] program that logs in to
[intranet.bygglogistik.se][] and reads and processes the data there.

[`bygglogistik-utils`]: https://git.rcrnstn.net/rcrnstn/bygglogistik-utils
[scrape]: https://en.wikipedia.org/wiki/Web_scraping
[intranet.bygglogistik.se]: http://intranet.bygglogistik.se
[Python]: https://www.python.org

## Usage

`bygglogistik-utils --help`:

```
bygglogistik-utils 1.0.0

Scrape intranet.bygglogistik.se.

Usage:
  bygglogistik-utils pay [--tax=<tax>]
  bygglogistik-utils personnel
  bygglogistik-utils report [<date_from>] [<date_to>] [<region>] [<project>]
  bygglogistik-utils path
  bygglogistik-utils -h|--help
  bygglogistik-utils --version

Arguments:
  <date_from>
    The date (in a ISO 8601 format) from which to gather reports (inclusive).
    Defaults to yesterday.
  <date_to>
    The date (in a ISO 8601 format) to which to gather reports (inclusive).
    Defaults to <date_from>.
  <region>
    The region of the report.
    Defaults to the region of the logged in user.
  <project>
    The project of the report.
    Default to all projects.

Options:
  --tax=<tax>
    The tax rate, between 0.0 and 1.0.
    Defaults to 0.30.
```

Data is stored in a path retrievable by running `bygglogistik-utils path`. This
path can be overridden with the [environment variable][] `BYGGLOGISTIK_PATH`.

Login uses the credentials in the file `$BYGGLOGISTIK_PATH/login` which should
be in [JSON][] format consisting of an object with the keys `email` and
`password`:

```json
{
    "email": "name@example.com",
    "password": "mysupersecretpassword"
}
```

Login credentials can be overridden by the [environment variable][]s
`BYGGLOGISTIK_EMAIL` and `BYGGLOGISTIK_PASSWORD`.

[environment variable]: https://en.wikipedia.org/wiki/Environment_variable
[JSON]: https://en.wikipedia.org/wiki/JSON

### `pay` command

Stores and summarizes personal payment data by parsing the table "Genomförda
intransporter" on the page "Mina sidor".

Since only the most recent data is shown in the table it then stores it locally
in `$BYGGLOGISTIK_PATH/pay` to enable accumulation over time (e.g. from a
[cron][] job). The format is [tab-separated values][], human and machine
readable and suitable for use with spreadsheet software.

Lastly, the expected pay, after taxes (which rate can be given with `--tax`,
defaults to `0.3`), for the months where data is available is printed, in
reverse chronological order.

[cron]: https://en.wikipedia.org/wiki/Cron
[tab-separated values]: https://en.wikipedia.org/wiki/Tab-separated_values

### `personnel` command

Prints the name, telephone number and position in the organization separated by
tab, one person per row, by parsing the table "Användare" on the page
"Användare".

Only tested on accounts that have the "Leveransplanerare" access permissions!

### `report` command

Prints statistics of a given report.

Only tested on accounts that have the "Leveransplanerare" access permissions!

## Install

Make sure [Python is installed][Python download], [`pip`][] is available and
the [`pip`][], [`setuptools`][] and [`wheel`][] packages are up to date:

```sh
python3 -m pip install --user --upgrade pip setuptools wheel
```

Reference: [Python Packaging User Guide: Requirements for Installing
Packages][].

[Python download]: https://python.org/download
[`pip`]: https://pip.readthedocs.io
[`setuptools`]: https://setuptools.readthedocs.io
[`wheel`]: https://wheel.readthedocs.io
[Python Packaging User Guide: Requirements for Installing Packages]: https://packaging.python.org/tutorials/installing-packages/#requirements-for-installing-packages

### With [`pipx`][], for users

Make sure [`pipx`][] is installed:

```sh
python3 -m pip install --user pipx
```

Install `bygglogistik-utils`:

```sh
pipx install "git+https://git.rcrnstn.net/rcrnstn/bygglogistik-utils"
```

`bygglogistik-utils` should now be in your [`PATH`][] (if not, run `python3 -m
pipx ensurepath`).

Reference: [Python Packaging User Guide: Installing stand alone command line
tools][].

[`pipx`]: https://pipxproject.github.io/pipx/
[`PATH`]: https://en.wikipedia.org/wiki/PATH_(variable)
[Python Packaging User Guide: Installing stand alone command line tools]: https://packaging.python.org/guides/installing-stand-alone-command-line-tools/

### Into [`venv`][], for developers

Clone and install into a repository [`venv`][] virtual environment:

```sh
git clone "https://git.rcrnstn.net/rcrnstn/bygglogistik-utils"
cd "bygglogistik-utils"
python3 -m venv .venv
. .venv/bin/activate
python3 -m pip install --editable .
```

`bygglogistik-utils` should now be in your (virtual environment) [`PATH`][].

Reference: [Python Packaging User Guide: Installing packages using pip and
virtual environments][].

[`venv`]: https://docs.python.org/3/library/venv.html
[Python Packaging User Guide: Installing packages using pip and virtual environments]: https://packaging.python.org/guides/installing-using-pip-and-virtual-environments/

## License

Licensed under the [ISC License][] unless otherwise noted, see the
[`LICENSE`][] file.

[ISC license]: https://choosealicense.com/licenses/isc/
[`LICENSE`]: LICENSE
