# [`ansible-role-xsession`][]

An [Ansible][] [role][] for deploying custom [X][] session [`.desktop`][] file.

Adds a `/etc/X11/sessions/Xsession.desktop` file that is picked up by [X
display manager][]s and, if chosen, runs `/etc/X11/Xsession` (which probably
runs your `$HOME/.xsession`).

[`ansible-role-xsession`]: https://git.rcrnstn.net/rcrnstn/ansible-role-xsession
[Ansible]: https://docs.ansible.com/ansible
[role]: https://docs.ansible.com/ansible/latest/user_guide/playbooks_reuse_roles.html
[X]: https://en.wikipedia.org/wiki/X_Window_System
[`.desktop`]: https://specifications.freedesktop.org/desktop-entry-spec/latest/index.html#introduction
[X display manager]: https://en.wikipedia.org/wiki/X_display_manager

## Usage

Example [`requirements.yml`][]:

```yaml
---

roles:
  - name: 'xsession'
    src: 'https://git.rcrnstn.net/rcrnstn/ansible-role-xsession'
    scm: 'git'
```

Example [playbook][]:

```yaml
---

- hosts: 'all'
  roles:
    - role: 'xsession'
```

[`requirements.yml`]: https://docs.ansible.com/ansible/latest/galaxy/user_guide.html#installing-multiple-roles-from-a-file
[playbook]: https://docs.ansible.com/ansible/latest/user_guide/playbooks.html

## License

Licensed under the [ISC License][] unless otherwise noted, see the
[`LICENSE`][] file.

[ISC License]: https://choosealicense.com/licenses/isc/
[`LICENSE`]: LICENSE
