# [`ansible-role-gitolite`][]

An [Ansible][] [role][] for deploying [gitolite][] on [Debian][] >=9.

Installs [gitolite][], creates a [dedicated user][] to run it (defaults to
`git`), prepares for [administering gitolite directly on the server][], and
allows [user created repos][] with [multiple `OWNERS`][] and `user/USER/*`
[personal branches][] for `USERS`.

[`ansible-role-gitolite`]: https://git.rcrnstn.net/rcrnstn/ansible-role-gitolite
[Ansible]: https://docs.ansible.com/ansible
[role]: https://docs.ansible.com/ansible/latest/user_guide/playbooks_reuse_roles.html
[gitolite]: https://gitolite.com
[Debian]: https://www.debian.org
[dedicated user]: https://gitolite.com/gitolite/concepts#the-hosting-user
[administering gitolite directly on the server]: https://gitolite.com/gitolite/odds-and-ends#administering-gitolite-directly-on-the-server
[user created repos]: https://gitolite.com/gitolite/odds-and-ends#giving-users-their-own-repos
[multiple `OWNERS`]: https://gitolite.com/gitolite/wild#specifying-owners
[personal branches]: https://gitolite.com/gitolite/user#personal-branches

## Try out

A stand-in [`site.yml`][] [playbook][] is provided, use it with

```
ansible-playbook -K -i $host, site.yml
```

(note the comma!) replacing `$host` with the host you want to set up (can be
`localhost`, perhaps adding `--connection=local`).

A [`Vagrantfile`][] that uses it is also provided, try it out with the usual
[`vagrant up`][].

[`site.yml`]: site.yml
[playbook]: https://docs.ansible.com/ansible/latest/user_guide/playbooks.html
[`Vagrantfile`]: Vagrantfile
[`vagrant up`]: https://www.vagrantup.com/docs/cli/up.html

## License

Licensed under the [ISC License][] unless otherwise noted, see the
[`LICENSE`][] file.

[ISC License]: https://choosealicense.com/licenses/isc/
[`LICENSE`]: LICENSE
