# [`ansible-role-firefox-extensions`][]

An [Ansible][] [role][] for installing [Firefox][] [extension][]s.

Takes a list of extension [slug][]s (the part after
`https://addons.mozilla.org/en-US/firefox/addon/`) and downloads and places the
extensions in the `extensions` directory in the default profile (a subdirectory
of `$HOME/.mozilla/firefox/`).

Note that, unless `extensions.autoDisableScopes` is set to an appropriate value
in `user.js`, extensions have to be enabled manually (e.g. from "Extensions" in
`about:addons`).

[`ansible-role-firefox-extensions`]: https://git.rcrnstn.net/rcrnstn/ansible-role-firefox-extensions
[Ansible]: https://docs.ansible.com/ansible
[role]: https://docs.ansible.com/ansible/latest/user_guide/playbooks_reuse_roles.html
[Firefox]: https://en.wikipedia.org/wiki/Firefox
[extension]: https://en.wikipedia.org/wiki/Firefox#Browser_extensions
[slug]: https://en.wikipedia.org/wiki/Clean_URL#Slug

## Usage

Example [`requirements.yml`][]:

```yaml
---

roles:
  - name: 'firefox-extensions'
    src: 'https://git.rcrnstn.net/rcrnstn/ansible-firefox-extensions'
    scm: 'git'
```

Example [playbook][]:

```yaml
---

- hosts: 'all'
  roles:
    - role: 'firefox-extensions'
      firefox_extensions:
        - 'ublock-origin'
        - 'old-reddit-redirect'
        - 'tridactyl-vim'
```

[`requirements.yml`]: https://docs.ansible.com/ansible/latest/galaxy/user_guide.html#installing-multiple-roles-from-a-file
[playbook]: https://docs.ansible.com/ansible/latest/user_guide/playbooks.html

## License

Licensed under the [ISC License][] unless otherwise noted, see the
[`LICENSE`][] file.

[ISC License]: https://choosealicense.com/licenses/isc/
[`LICENSE`]: LICENSE
