# [`ansible-role-dotfiles`][]

An [Ansible][] [role][] for deploying [dotfile][]s on [Unix-like][]s.

Takes [Git][] repository [URL][]s in the variable `dotfiles`, clones them into
subdirectories of `$HOME/.dotfiles` (overridable with the variable
`dotfiles_dir`) and uses [`stow`][] (which must be present on the target
system!) to [symlink][] the contents into the parent directory of
`dotfiles_dir` (overridable with the variable `dotfiles_target`).

[`ansible-role-dotfiles`]: https://git.rcrnstn.net/rcrnstn/ansible-role-dotfiles
[Ansible]: https://docs.ansible.com/ansible
[role]: https://docs.ansible.com/ansible/latest/user_guide/playbooks_reuse_roles.html
[dotfile]: https://en.wikipedia.org/wiki/Hidden_file_and_hidden_directory#Unix_and_Unix-like_environments
[Unix-like]: https://en.wikipedia.org/wiki/Unix-like
[Git]: https://git-scm.com
[URL]: https://en.wikipedia.org/wiki/URL
[symlink]: https://en.wikipedia.org/wiki/Symbolic_link
[`stow`]: https://www.gnu.org/software/stow/

## Usage

Example [`requirements.yml`][]:

```yaml
---

roles:
  - name: 'dotfiles'
    src: 'https://git.rcrnstn.net/rcrnstn/ansible-role-dotfiles'
    scm: 'git'
```

Example [playbook][]:

```yaml
---

- hosts: 'all'
  roles:
    - role: 'dotfiles'
      dotfiles:
        - 'https://github.com/user/dotfiles-program1'
        - 'https://github.com/user/dotfiles-program2'
```

[`requirements.yml`]: https://docs.ansible.com/ansible/latest/galaxy/user_guide.html#installing-multiple-roles-from-a-file
[playbook]: https://docs.ansible.com/ansible/latest/user_guide/playbooks.html

## License

Licensed under the [ISC License][] unless otherwise noted, see the
[`LICENSE`][] file.

[ISC License]: https://choosealicense.com/licenses/isc/
[`LICENSE`]: LICENSE
